﻿//////////////////////////////////////////////
// EntityRenderInfoSlot.h
// 
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkGraphics
{
	class Entity ;
	class Mesh ;
}

/// Includes ---------------------------------

// nkGraphics
#include "../Dll/DllDefines.h"

#include "EntityRenderLodSlot.h"

// nkExport
#include <NilkinsExport/Exportable/Exportable.h>

// nkMemory
#include <NilkinsMemory/Containers/BufferCast.h>

/// Class ------------------------------------

namespace nkGraphics
{
	class DLL_GRAPHICS_EXPORT EntityRenderInfoSlot final : public nkExport::Exportable
	{
		public :

			// Constructor, destructor
			EntityRenderInfoSlot () noexcept ;
			EntityRenderInfoSlot (const EntityRenderInfoSlot& other) noexcept ;
			EntityRenderInfoSlot (EntityRenderInfoSlot&& other) noexcept ;
			EntityRenderInfoSlot (Mesh* mesh, Shader* shader) noexcept ;
			virtual ~EntityRenderInfoSlot () ;

			// Getters
			EntityRenderLodSlot* getLod (unsigned int index) const ;
			const nkMemory::BufferCast<EntityRenderLodSlot*>& getLods () const ;
			Entity* getParentEntity () const ;

			// Manipulations
			EntityRenderLodSlot* addLod (const EntityRenderLodSlot& lodSlot = EntityRenderLodSlot()) ;
			void eraseLod (unsigned int index) ;

			// Operators
			EntityRenderInfoSlot& operator= (const EntityRenderInfoSlot& other) noexcept ;
			EntityRenderInfoSlot& operator= (EntityRenderInfoSlot&& other) noexcept ;

			// Import / Export
			virtual void exportClassToTree (nkExport::Node* rootNode) override ;
			virtual void importClassFromTree (nkExport::Node* rootNode) override ;

		private :

			// Functions
			void _setParentEntity (Entity* entity) ;

		private :

			// Attributes
			nkMemory::BufferCast<EntityRenderLodSlot*> _lods ;

			Entity* _parentEntity ;

		private :

			friend class EntityRenderInfo ;
	} ;
}